package boot;

import org.pgusb.usbDllAdapter.ReadBytes;
import org.pgusb.usbDllAdapter.UsbDllAdapter;
import org.pgusb.usbDllAdapter.WriteBytes;

import usb4all.HandlerPacket;
import usb4all.PcHandlerManager;

public class BootLoaderModule {

	static final int MP_WRITE=0;
	static final int MP_READ=1;
	static final int INVALID_HANDLE_VALUE=-1;
	static final String vid_pid= "vid_04d8&pid_000c";
	private int selection;
	private int myOutPipe=-1;
	private int myInPipe=-1;
	private int handler;
	private PcHandlerManager phm;
	private int endpin;
	private int endpout;
	
	public void init(int sel,int handler,int endpin, int endpout){
		selection = sel;
		this.handler = handler;
		this.endpin= endpin;
		this.endpout=endpout;
		phm=new PcHandlerManager(handler);
	}
	
	public ReadBytes SendReceivePacket(int myOutPipe, int myInPipe,byte[] SendData, int SendLength,
			int ReceiveLength,int SendDelay, int ReceiveDelay) {
		
		int ExpectedReceiveLength = ReceiveLength; 
		
		if(myOutPipe != INVALID_HANDLE_VALUE && myInPipe != INVALID_HANDLE_VALUE){
			try {
				WriteBytes wb = UsbDllAdapter.MPUSBWrite(myOutPipe,SendData,SendLength,SendDelay);
				//System.out.println("Quiero write: " + SendLength + " Writed Bytes : "+ wb.getLength()+ " retval: "+ wb.getRetVal());
				if (wb.getRetVal()!=0) {
					ReadBytes rb = UsbDllAdapter.MPUSBRead(myInPipe, ExpectedReceiveLength,ReceiveDelay);
					//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
					if(rb.getRetVal()!=0) {
				        if(rb.getLength() == ExpectedReceiveLength){
				            return new ReadBytes(rb.getReadBytes(),rb.getLength(),1);   // Success!
				        }
				        else if(rb.getLength() < ExpectedReceiveLength)
				        {
				            return new ReadBytes(rb.getReadBytes(),rb.getLength(),2);   // Partially failed, incorrect receive length
				        }//end if else
				    }
				}
			}//end if
			catch (Exception e){
				System.out.println("Excepcion en SendReceivePacket");
			}
		}
		return new ReadBytes(null,0,-1);  // Operation Failed
	}//end SendReceivePacket

	
	public boolean open(){
		String out_pipe= "\\MCHP_EP"+endpout;
		String in_pipe= "\\MCHP_EP"+endpin;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
	    {
	        System.out.println("Failed to open data pipes.\r\n");
	        return false;
	    }//end if

		System.out.println("BOOTLOADER MODULE myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);
		return true;
	}
	public boolean close(){
	    try {
			
		    UsbDllAdapter.MPUSBClose(myOutPipe);
		    UsbDllAdapter.MPUSBClose(myInPipe);
		    }
		    catch (Exception e){
		    	System.out.println("error a hacer el close");
		    	System.out.println(e.getMessage());
		    	return false;
		    }
		    myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
		return true;
	}
	
	public byte[] readFlash(int address,int len) {
		System.out.println("Read de direccion:" + Integer.toHexString(address));
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_FLASH,address,len,null);
		System.out.print("payload enviado: ");
		printBinData(bdp.getCommand());
		int RecvLength=len+BootDataPacket.OVER_HEAD+HandlerPacket.OVER_HEAD;
		HandlerPacket hp = phm.send(bdp.getCommand()); //agrego el header 
		System.out.print("packet enviado: ");
		printBinData(hp.getPacket());
	    //System.out.println(send_buf.toString());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,hp.getPacket(),hp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
	    	HandlerPacket hpresp = new HandlerPacket();	//parseo el paquete de salida
	    	hpresp.parsePacket(rb.getReadBytes());//saco el payload 
	    	System.out.print("packet recibido: ");
			printBinData(hpresp.getPacket());
	    	resp.parse(hpresp.getPayload());
			System.out.print("payload recibido: ");
			printBinData(hpresp.getPayload());
			resp.getAdr_upper();
			resp.getAdr_high();
			resp.getAdr_low();
			
	    	//resp.printBinData();
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return resp.getData();
	}

	
	public byte[] getVersion() {
		int len = 4;
		BootDataPacket resp = new BootDataPacket();
	    //genero payload con mensaje de read version para el bootloader
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_VERSION,0,len,null);
		System.out.print("payload enviado: ");
	    bdp.printBinData();
	    int RecvLength=len+HandlerPacket.OVER_HEAD;
		//System.out.println(send_buf.toString());
		HandlerPacket hp = phm.send(bdp.getPacket()); //agrego el header 
		System.out.print("packet enviado: ");
		printBinData(hp.getPacket());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,hp.getPacket(),hp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
	    	HandlerPacket hpresp = new HandlerPacket();	//parseo el paquete de salida
	    	hpresp.parsePacket(rb.getReadBytes());//saco el payload 
	    	System.out.print("packet recibido: ");
			printBinData(hpresp.getPacket());
	    	resp.parse(hpresp.getPayload());
			System.out.print("payload recibido: ");
			//printBinData(hpresp.getPayload());
			resp.printBinData();
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return null;
	}
	public byte[] reset() {
		int len = 4;
		BootDataPacket resp = new BootDataPacket();
	    //genero payload con mensaje de read version para el bootloader
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.RESET,0,len,null);
		System.out.print("payload enviado: ");
	    bdp.printBinData();
	    int RecvLength=len+HandlerPacket.OVER_HEAD;
		//System.out.println(send_buf.toString());
		HandlerPacket hp = phm.send(bdp.getPacket()); //agrego el header 
		System.out.print("packet enviado: ");
		printBinData(hp.getPacket());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,hp.getPacket(),hp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
	    	HandlerPacket hpresp = new HandlerPacket();	//parseo el paquete de salida
	    	hpresp.parsePacket(rb.getReadBytes());//saco el payload 
	    	System.out.print("packet recibido: ");
			printBinData(hpresp.getPacket());
	    	resp.parse(hpresp.getPayload());
			System.out.print("payload recibido: ");
			printBinData(hpresp.getPayload());
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return null;
	}
	
	public boolean writeFlash(int address,byte[] data) {
		System.out.println("Write de direccion:" + Integer.toHexString(address));
		BootDataPacket resp = new BootDataPacket();
		boolean respb=false;
		if (data!=null && data.length<=16){
			int len=data.length;
	    	BootDataPacket bdp = new BootDataPacket(BootDataPacket.WRITE_FLASH,address,len,data);
	    	System.out.print("payload enviado: ");
			bdp.printBinData();
			HandlerPacket hp = phm.send(bdp.getPacket()); //agrego el header 
			System.out.print("packet enviado: ");
			printBinData(hp.getPacket());
		    int RecvLength=1+HandlerPacket.OVER_HEAD;
		    //System.out.println(send_buf.toString());
		    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,hp.getPacket(),hp.getPacket().length,RecvLength,1000,1000);
		    if(rb.getRetVal() == 1)
		    {
		    	
		    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
		    	HandlerPacket hpresp = new HandlerPacket();	//parseo el paquete de salida
		    	hpresp.parsePacket(rb.getReadBytes());//saco el payload 
		    	System.out.print("packet recibido: ");
				printBinData(hpresp.getPacket());
		    	resp.parse(hpresp.getPayload()); //TODO REVISAR
				System.out.print("payload recibido: ");
				//printBinData(hpresp.getPayload());
				resp.printBinData();
				
		    	//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
				/*
				if (resp.getData()[0+BootDataPacket.OVER_HEAD]==BootDataPacket.WRITE_FLASH){
					respb = true;
				}
				*/
		    }
		    else {
		        System.out.println("USB Operation Failed\r\n");
		    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		    }
	    }
		return respb;
	}
	
	
	
	public boolean eraseFlash(int address) {
		System.out.println("Erase de direccion:" + Integer.toHexString(address));
		boolean resp2=false;
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.ERASE_FLASH,address,5,null);
	    System.out.print("payload enviado: ");
	    bdp.printBinData();
	    int RecvLength=1+HandlerPacket.OVER_HEAD;
		//System.out.println(send_buf.toString());
		HandlerPacket hp = phm.send(bdp.getPacket()); //agrego el header 
		System.out.print("packet enviado: ");
		printBinData(hp.getPacket());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,hp.getPacket(),hp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
	    	HandlerPacket hpresp = new HandlerPacket();	//parseo el paquete de salida
	    	hpresp.parsePacket(rb.getReadBytes());//saco el payload 
	    	System.out.print("packet recibido: ");
			printBinData(hpresp.getPacket());
	    	resp.parse(hpresp.getPayload());
			System.out.print("payload recibido: ");
			//printBinData(hpresp.getPayload());
			resp.printBinData();
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return resp2;
	}
	
	public boolean eraseFlashold(int address) {
		boolean resp=false;
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.ERASE_FLASH,address,5,null);
		bdp.printBinData();
		int RecvLength=1+HandlerPacket.OVER_HEAD;;
	    //System.out.println(send_buf.toString());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,bdp.getPacket(),bdp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			if (rb.getReadBytes()[0+HandlerPacket.OVER_HEAD]==BootDataPacket.ERASE_FLASH){
				resp = true;
			}
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return resp;
	}

	public void printBinData(byte[] c){
		
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
}
